function [d]=indirect_inference_OU_crude_noise(par,coeffs,W);

% Purpose: Compute the criterion function as the squared difference between mean(beta_S) and beta_hat for the OU
% model with noise

% input: par: structural parameters (4x1) vector
%        coeffs: auxiliary estimates (4x1) vector 
%       W : matrix of innovations (Tx2xH)


H=size(W,3);

beta=zeros(4,H);  % preallocate beta_S

% retransform the structural coefficients (they have to be non-negative)

mu=exp(par(1));

sigma=exp(par(2));

kappa=exp(par(3));

sigma_u=exp(par(4));

params=[mu,sigma,kappa,sigma_u];

for j=1:H;
    
    w=W(:,:,j);
    
    [y]=simulate_OU_exact(params,w(:,1));
    
    x=y+w(:,2)*sigma_u;
    
    [beta_hat]=crude_discretrization_OLS(x);  % estimate the AR(1) model with intercept and variance of x
    
    beta(:,j) = [beta_hat];  

end;
 beta_star=mean(beta')'-coeffs; % compute the difference mean(beta_S)-beta_hat
 
 d=beta_star'*beta_star; % sum of the squared differences (no weigthing requied as p=q)
